﻿using Riantsoft.P2pServer.View;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Riantsoft.P2pServer.P2pServer
{
    static class Program
    {
        /// <summary>
        /// 应用程序的主入口点。
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            ServerMainForm mainForm = new ServerMainForm();

            bool autoStart = IsSpecialArgs(args, "-start");
            if (autoStart)
                mainForm.StartProcess();

            Application.Run(mainForm);
        }

        /// <summary>
        /// 判断是否包含重启运行程序的运行参数
        /// </summary>
        /// <param name="args">命令参数组</param>
        /// <param specialArgs="args">包含的特色命令</param>
        /// <returns>是否包含特定命令</returns>
        static bool IsSpecialArgs(string[] args, string specialArgs)
        {
            if (args.Length > 0)
            {
                foreach (string item in args)
                {
                    if (item.ToLower().Equals(specialArgs, StringComparison.OrdinalIgnoreCase))
                    {
                        return true;
                    }
                }
                return false;
            }
            else
                return false;
        }
    }
}
